/**
 * assets/js/admin-scripts.js
 * Scripts para a área administrativa do plugin.
 * @version 2.7
 */
document.addEventListener('DOMContentLoaded', () => {

    // Lógica para a página de listagem de plugins (sem alterações)
    document.querySelectorAll('.plugin-action-button').forEach(button => {
        button.addEventListener('click', e => {
            e.preventDefault();
            if (button.disabled || (button.dataset.state !== 'update' && button.dataset.state !== 'install' && button.dataset.state !== 'activate')) return;
            const originalText = button.textContent;
            button.disabled = true;

            let actionName = 'meu_repositorio_update_plugin';
            if (button.dataset.state === 'install') {
                button.textContent = 'Instalando...';
            } else if (button.dataset.state === 'activate') {
                button.textContent = 'Ativando...';
                actionName = 'meu_repositorio_activate_plugin';
            } else {
                button.textContent = mrp_ajax.text.updating;
            }

            const formData = new URLSearchParams({
                action: actionName,
                plugin_url: button.dataset.pluginUrl || '',
                plugin_file: button.dataset.pluginFile || '',
                security: mrp_ajax.nonce
            });
            fetch(mrp_ajax.ajax_url, { method: 'POST', body: formData })
                .then(response => response.json())
                .then(data => {
                    alert(data.success ? data.data.message : `${mrp_ajax.text.error} ${data.data.message || ''}`);
                    if (data.success) location.reload();
                    else { button.disabled = false; button.textContent = originalText; }
                })
                .catch(() => { button.disabled = false; button.textContent = originalText; alert(mrp_ajax.text.fatal_error); });
        });
    });

    // Lógica para o botão de forçar verificação (sem alterações)
    const forceUpdateButton = document.getElementById('mrp-force-update-button');
    if (forceUpdateButton) {
        forceUpdateButton.addEventListener('click', e => {
            e.preventDefault();
            const button = e.target.closest('button');
            button.disabled = true;
            button.innerHTML = `<span class="dashicons dashicons-update spin"></span> ${mrp_ajax.text.force_update_running}`;
            const formData = new URLSearchParams({ action: 'meu_repositorio_force_update', security: mrp_ajax.nonce });
            fetch(mrp_ajax.ajax_url, { method: 'POST', body: formData })
                .then(response => response.json())
                .then(data => {
                    alert(data.success ? data.data.message : `${mrp_ajax.text.error} ${data.data.message || ''}`);
                    location.reload();
                })
                .catch(() => location.reload());
        });
    }

    // NOVO: Feedback visual ao salvar configurações
    const settingsForm = document.querySelector('form[action="options.php"]');
    if (settingsForm) {
        settingsForm.addEventListener('submit', () => {
            const submitButton = settingsForm.querySelector('input[type="submit"].button-primary');
            if (submitButton) {
                submitButton.value = mrp_ajax.text.saving;
                submitButton.disabled = true;
            }
        });
    }
});