<?php
/**
 * Funções para a página de configurações do repositório.
 * @version 3.0
 */

add_action('admin_init', 'mrp_register_settings');

/**
 * Registra as seções e campos de configuração do plugin.
 */
function mrp_register_settings() {
    register_setting('mrp_settings_group', 'meu_repositorio_api_url', 'mrp_sanitize_url');
    register_setting('mrp_settings_group', 'meu_repositorio_auto_update_enabled', 'mrp_sanitize_checkbox');

    // Seção Principal
    add_settings_section('mrp_main_settings_section', __('Configurações Principais', 'meu-repositorio-client'), 'mrp_main_section_callback', 'meu-repositorio-settings');
    add_settings_field('meu_repositorio_api_url_field', __('URL do Endpoint JSON', 'meu-repositorio-client'), 'mrp_url_field_callback', 'meu-repositorio-settings', 'mrp_main_settings_section');

    // Seção de Atualizações Automáticas
    add_settings_section('mrp_auto_update_section', __('Atualizações Automáticas', 'meu-repositorio-client'), 'mrp_auto_update_section_callback', 'meu-repositorio-settings');
    add_settings_field('mrp_auto_update_enabled_field', __('Habilitar Cron Externo', 'meu-repositorio-client'), 'mrp_auto_update_enabled_callback', 'meu-repositorio-settings', 'mrp_auto_update_section');
}

/**
 * Renderiza o contêiner da página de configurações.
 */
function mrp_render_settings_page() {
    ?>
    <div class="wrap mrp-wrap">
        <h1 class="mrp-header">
            <span class="dashicons dashicons-admin-settings"></span>
            <?php esc_html_e('Configurações do Repositório', 'meu-repositorio-client'); ?>
        </h1>

        <?php
        // Exibe notificações de "Configurações salvas."
        settings_errors();
        ?>

        <form method="post" action="options.php" class="mrp-form">
            <?php settings_fields('mrp_settings_group'); ?>
            <div class="mrp-card">
                <?php do_settings_sections('meu-repositorio-settings'); ?>
            </div>
            <?php submit_button(__('Salvar Alterações', 'meu-repositorio-client')); ?>
        </form>
        
        <p class="mrp-footer-ad" style="text-align: right; font-size: 11px; margin-top: 15px; color: #a0a0a0;">
            <?php _e('Serviços Profissionais por', 'meu-repositorio-client'); ?> <a href="https://wpmasters.com.br" target="_blank" style="color: #a0a0a0; text-decoration: none; font-weight: 500;">WP Masters</a>
        </p>
        </div>
    <?php
}

/**
 * Callbacks das seções de configuração (textos descritivos).
 */
function mrp_main_section_callback() {
    echo '<p>' . esc_html__('Insira a URL completa do seu repositório de onde os plugins serão buscados.', 'meu-repositorio-client') . '</p>';
}

function mrp_auto_update_section_callback() {
    $cron_url = MRP_PLUGIN_URL . 'cron-update.php';
    echo '<p>' . esc_html__('Permita que os plugins sejam atualizados automaticamente por um script externo (cron job).', 'meu-repositorio-client') . '</p>';
    echo '<p class="description">' . sprintf(
        esc_html__('Você deve configurar um cron job no seu servidor para acessar a URL: %s. A frequência recomendada é diária.', 'meu-repositorio-client'),
        '<code>curl -k ' . esc_url($cron_url) . '</code>'
    ) . '</p>';
}

/**
 * Callbacks para renderizar os campos do formulário.
 */
function mrp_url_field_callback() {
    $api_url = get_option('meu_repositorio_api_url', '');
    echo '<input type="url" name="meu_repositorio_api_url" id="meu_repositorio_api_url" value="' . esc_attr($api_url) . '" class="regular-text" placeholder="https://seu-dominio.com/wp-json/wp/v2/plugins" style="max-width: 100%;">';
}

function mrp_auto_update_enabled_callback() {
    $is_enabled = get_option('meu_repositorio_auto_update_enabled', 0);
    echo '<label><input type="checkbox" name="meu_repositorio_auto_update_enabled" id="meu_repositorio_auto_update_enabled" value="1" ' . checked(1, $is_enabled, false) . '> ' . esc_html__('Habilitar atualizações automáticas via cron', 'meu-repositorio-client') . '</label>';
    echo '<p class="description">' . esc_html__('Permite que o script de cron execute as atualizações quando chamado externamente.', 'meu-repositorio-client') . '</p>';
}

/**
 * Funções de sanitização para os campos salvos.
 */
function mrp_sanitize_url($input) {
    return !empty($input) ? esc_url_raw(trim($input)) : '';
}

function mrp_sanitize_checkbox($input) {
    return (isset($input) && $input == 1) ? 1 : 0;
}