<?php
/**
 * Funções para a página de configurações do repositório.
 * @version 2.8
 */

add_action('admin_init', 'mrp_register_settings');

function mrp_register_settings() {
    register_setting('mrp_settings_group', 'meu_repositorio_api_url', 'mrp_sanitize_url');
    register_setting('mrp_settings_group', 'meu_repositorio_license_token', 'sanitize_text_field');
    register_setting('mrp_settings_group', 'meu_repositorio_auto_update_enabled', 'mrp_sanitize_checkbox');

    add_settings_section('mrp_main_settings_section', __('Conexão', 'meu-repositorio-client'), 'mrp_main_section_callback', 'meu-repositorio-settings');
    add_settings_field('meu_repositorio_api_url_field', __('URL do Endpoint', 'meu-repositorio-client'), 'mrp_url_field_callback', 'meu-repositorio-settings', 'mrp_main_settings_section');
    add_settings_field('meu_repositorio_license_token_field', __('Token do Cliente', 'meu-repositorio-client'), 'mrp_license_token_field_callback', 'meu-repositorio-settings', 'mrp_main_settings_section');

    add_settings_section('mrp_auto_update_section', __('Automação', 'meu-repositorio-client'), 'mrp_auto_update_section_callback', 'meu-repositorio-settings');
    add_settings_field('mrp_auto_update_enabled_field', __('Cron Externo', 'meu-repositorio-client'), 'mrp_auto_update_enabled_callback', 'meu-repositorio-settings', 'mrp_auto_update_section');
}

function mrp_render_settings_page() {
    ?>
    <div class="wrap mrp-wrap">
        <header class="mrp-header-bar">
            <h1 class="mrp-page-title">
                <?php esc_html_e('Configurações', 'meu-repositorio-client'); ?>
            </h1>
        </header>

        <form method="post" action="options.php" class="mrp-form">
            <?php settings_fields('mrp_settings_group'); ?>
            
            <div class="mrp-content-card">
                <?php do_settings_sections('meu-repositorio-settings'); ?>
            </div>
            
            <p class="submit">
                <?php submit_button(__('Salvar Alterações', 'meu-repositorio-client'), 'primary mrp-button mrp-button-primary', 'submit', false); ?>
            </p>
        </form>
        
        <footer class="mrp-footer">
            Desenvolvido por <a href="https://wpmasters.com.br" target="_blank">WP Masters</a>
        </footer>
    </div>
    <?php
}

function mrp_main_section_callback() {
    echo '<p class="mrp-form-helper">' . esc_html__('Configure a conexão com o repositório mestre.', 'meu-repositorio-client') . '</p>';
}

function mrp_auto_update_section_callback() {
    $cron_url = MRP_PLUGIN_URL . 'cron-update.php';
    echo '<p class="mrp-form-helper">' . sprintf(
        esc_html__('Endpoint para Cron Job: %s', 'meu-repositorio-client'),
        '<code style="background: #f1f5f9; padding: 2px 5px; border-radius: 4px;">curl -k ' . esc_url($cron_url) . '</code>'
    ) . '</p>';
}

function mrp_url_field_callback() {
    $api_url = get_option('meu_repositorio_api_url', '');
    echo '<input type="url" name="meu_repositorio_api_url" value="' . esc_attr($api_url) . '" placeholder="https://api.exemplo.com/wp-json/..." />';
    echo '<p class="mrp-form-helper">' . esc_html__('URL fornecida pelo provedor do repositório.', 'meu-repositorio-client') . '</p>';
}

function mrp_license_token_field_callback() {
    $token = get_option('meu_repositorio_license_token', '');
    echo '<input type="password" name="meu_repositorio_license_token" value="' . esc_attr($token) . '" class="regular-text" placeholder="Insira o token de acesso..." />';
    echo '<p class="mrp-form-helper">' . esc_html__('Token para validar o acesso ao repositório.', 'meu-repositorio-client') . '</p>';
}

function mrp_auto_update_enabled_callback() {
    $is_enabled = get_option('meu_repositorio_auto_update_enabled', 0);
    echo '<label><input type="checkbox" name="meu_repositorio_auto_update_enabled" value="1" ' . checked(1, $is_enabled, false) . '> ' . esc_html__('Permitir execução via URL externa', 'meu-repositorio-client') . '</label>';
}

function mrp_sanitize_url($input) {
    return !empty($input) ? esc_url_raw(trim($input)) : '';
}

function mrp_sanitize_checkbox($input) {
    return (isset($input) && $input == 1) ? 1 : 0;
}